package com.qboxus.tictic.activitesfragments.livestreaming.fragments;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Animatable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

import com.downloader.Error;
import com.downloader.OnDownloadListener;
import com.downloader.OnProgressListener;
import com.downloader.PRDownloader;
import com.downloader.Progress;
import com.downloader.request.DownloadRequest;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.EditTextSheetFragment;
import com.qboxus.tictic.activitesfragments.livestreaming.activities.LiveUsersActivity;
import com.qboxus.tictic.activitesfragments.livestreaming.activities.MultiViewLiveActivity;
import com.qboxus.tictic.activitesfragments.livestreaming.adapter.LiveCommentsAdapter;
import com.qboxus.tictic.activitesfragments.livestreaming.adapter.LiveUserViewAdapter;
import com.qboxus.tictic.activitesfragments.livestreaming.model.CameraRequestModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveCoinsModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveCommentModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.PkInvitation;
import com.qboxus.tictic.activitesfragments.profile.ProfileActivity;
import com.qboxus.tictic.activitesfragments.profile.analytics.DateOperations;
import com.qboxus.tictic.activitesfragments.sendgift.StickerGiftFragment;
import com.qboxus.tictic.activitesfragments.sendgift.StickerModel;
import com.qboxus.tictic.activitesfragments.shoping.adapter.StreamingProductsAdapter;
import com.qboxus.tictic.activitesfragments.shoping.models.ProductModel;
import com.qboxus.tictic.apiclasses.ApiLinks;
import com.qboxus.tictic.databinding.FragmentMultipleStreamerListBinding;
import com.qboxus.tictic.interfaces.AdapterClickListener;
import com.qboxus.tictic.interfaces.FragmentCallBack;
import com.qboxus.tictic.models.StreamJoinModel;
import com.qboxus.tictic.models.StreamShowHeartModel;
import com.qboxus.tictic.models.UserModel;
import com.qboxus.tictic.models.UserOnlineModel;
import com.qboxus.tictic.simpleclasses.ApiRepository;
import com.qboxus.tictic.simpleclasses.DataParsing;
import com.qboxus.tictic.simpleclasses.DateOprations;
import com.qboxus.tictic.simpleclasses.Dialogs;
import com.qboxus.tictic.simpleclasses.FileUtils;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.OnSwipeTouchListener;
import com.qboxus.tictic.simpleclasses.TicTicApp;
import com.qboxus.tictic.simpleclasses.Variables;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ServerValue;
import com.google.firebase.database.ValueEventListener;
import com.volley.plus.VPackages.VolleyRequest;
import com.volley.plus.interfaces.APICallBack;
import com.volley.plus.interfaces.Callback;

import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;


public class MultipleStreamerListFragment extends Fragment implements View.OnClickListener {


    private final long DELAY = 20000;
    Context context;
    LiveUserModel item;
    MultiViewLiveActivity activity;
    DatabaseReference rootref;
    boolean isLikeStream = true;
    LiveUserViewAdapter liveUserViewAdapter;
    CountDownTimer selfInvitehandler;
    int selfInviteRemainingTime = 0;
    boolean isFirstTimeFlip = true;
    boolean isSendHeart = true;
    FragmentMultipleStreamerListBinding binding;
    ValueEventListener productChildListener;
    // initailze the adapter
    ArrayList<ProductModel> productsList = new ArrayList<>();
    StreamingProductsAdapter productsAdapter;
    ArrayList<UserModel> taggedUserList = new ArrayList<>();
    ChildEventListener commentChildListener;
    Calendar current_cal;
    // initailze the adapter
    ArrayList<LiveCommentModel> dataList = new ArrayList<>();
    LiveCommentsAdapter adapter;
    ValueEventListener cameraRequestEventListener;
    boolean isCameraConnect = false;
    ArrayList<StreamJoinModel> jointUserList = new ArrayList<>();
    ValueEventListener joinValueEventListener;
    ValueEventListener coinValueEventListener;
    ArrayList<LiveCoinsModel> senderCoinsList = new ArrayList<>();
    Handler pkGifHandler;
    Runnable pkGifRunable;
    CountDownTimer pkBattleCountDown;
    Handler winningHandler;
    Runnable winningRunnable;
    PkInvitation pkInvitation;
    ValueEventListener pklistener;
    // get the profile details of user
    boolean isRunFirstTime = false;
    boolean isAudioActivated = true, isVideoActivated = true, isbeautyActivated = true;
    MediaPlayer audio;
    MediaPlayer player;
    Handler handler;
    boolean isVisible = false;
    ValueEventListener userLiveStatusListener;
    ValueEventListener blockValueEventListener;
    ChildEventListener likeValueEventListener;
    int heartCounter = 0;
    ChildEventListener streamerOnlineListener;
    private Timer timer = new Timer();


    public MultipleStreamerListFragment(LiveUserModel item, MultiViewLiveActivity activity) {
        this.item = item;
        pkInvitation = item.pkInvitation;
        this.activity = activity;
    }

    public MultipleStreamerListFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_multiple_streamer_list, container, false);

        return binding.getRoot();
    }

    private void ActionControl() {

        final Animation inAnim = AnimationUtils.loadAnimation(context, R.anim.in_from_right);
        final Animation outAnim = AnimationUtils.loadAnimation(context, R.anim.out_to_left);
        final Animation inPrevAnim = AnimationUtils.loadAnimation(context, R.anim.in_from_left);
        final Animation outPrevAnim = AnimationUtils.loadAnimation(context, R.anim.out_to_right);


        binding.tabMainView.setOnTouchListener(new OnSwipeTouchListener(context) {
            public void onSwipeTop() {

            }

            public void onSwipeRight() {

                binding.viewflliper.setInAnimation(inPrevAnim);
                binding.viewflliper.setOutAnimation(outPrevAnim);
                binding.innerViewflliper.setInAnimation(inPrevAnim);
                binding.innerViewflliper.setOutAnimation(outPrevAnim);
                Log.d(Constants.tag, "start");

                if (binding.viewTwo == binding.viewflliper.getCurrentView()) {
                    if (binding.viewFour == binding.innerViewflliper.getCurrentView()) {
                        binding.innerViewflliper.showPrevious();
                    } else {
                        binding.viewflliper.showPrevious();
                    }
                } else {
                    binding.viewflliper.showPrevious();
                }

            }

            public void onSwipeLeft() {
                binding.viewflliper.setInAnimation(inAnim);
                binding.viewflliper.setOutAnimation(outAnim);
                binding.innerViewflliper.setInAnimation(inAnim);
                binding.innerViewflliper.setOutAnimation(outAnim);
                Log.d(Constants.tag, "end");
                if (binding.viewTwo == binding.viewflliper.getCurrentView()) {
                    if (binding.viewThree == binding.innerViewflliper.getCurrentView()) {
                        binding.innerViewflliper.showNext();
                    }

                } else {
                    binding.viewflliper.showNext();
                }


            }

            public void onSwipeBottom() {

            }

            @Override
            public void onDoubleClick(MotionEvent e) {
                if (isSendHeart) {
                    isSendHeart = true;
                    addLikeIntoStream();
                }
            }

            public void onSingleClick() {

            }
        });

        if (isFirstTimeFlip) {
            isFirstTimeFlip = false;
            if (binding.viewOne == binding.viewflliper.getCurrentView()) {
                binding.viewflliper.showNext();
            }
        }

        binding.tabMenu.setOnClickListener(this);
        binding.tabGift.setOnClickListener(this);
        binding.tabInviteAll.setOnClickListener(this);
        binding.tabCoHost.setOnClickListener(this);


        addMessages("joined");
    }

    public void addProductListener() {
        if (productChildListener == null) {
            initproductAdapter();
            Functions.printLog(Constants.tag, "addProductListener");

            productChildListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                    Functions.printLog(Constants.tag, dataSnapshot.toString());
                    productsList.clear();
                    if (dataSnapshot.exists()) {
                        binding.productRecylerVeiw.setVisibility(View.VISIBLE);
                        for (DataSnapshot product : dataSnapshot.getChildren()) {
                            ProductModel model = product.getValue(ProductModel.class);
                            productsList.add(model);

                        }
                        productsAdapter.notifyDataSetChanged();

                    } else {

                        binding.productRecylerVeiw.setVisibility(View.GONE);
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {
                    Functions.printLog(Constants.tag, databaseError.toString());
                    binding.productRecylerVeiw.setVisibility(View.GONE);
                }
            };

            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("productsList").addValueEventListener(productChildListener);
        }
    }

    public void removeProductListener() {
        if (rootref != null && productChildListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("productsList").removeEventListener(productChildListener);
            productChildListener = null;
        }
    }

    public void initproductAdapter() {

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
        binding.productRecylerVeiw.setLayoutManager(linearLayoutManager);
        binding.productRecylerVeiw.setHasFixedSize(true);

        SnapHelper snapHelper = new LinearSnapHelper();
        snapHelper.attachToRecyclerView(binding.productRecylerVeiw);

        productsAdapter = new StreamingProductsAdapter(context, productsList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {

//                AllBusinessMenuModel allBusinessItem = productsList.get(pos);
//                if (allBusinessItem.getBussinessType().equals("1"))
//                {
//                    MenuItemList model=allBusinessItem.getMenuItemModel();
//                    TaggedProductDetailFragment fragment = new TaggedProductDetailFragment();
//                    Bundle args = new Bundle();
//                    args.putParcelable("data", model);
//                    args.putParcelable("storeModel", allBusinessItem.getStoreModel());
//                    args.putString("type", "store");
//                    fragment.setArguments(args);
//                    fragment.show(getChildFragmentManager(), "TaggedProductDetailF2");
//                } else if (allBusinessItem.getBussinessType().equals("2"))
//                {
//                    StoreDishes model=allBusinessItem.getStoreModel();
//                    TaggedCustomProductDetailFragment fragment = new TaggedCustomProductDetailFragment();
//                    Bundle args = new Bundle();
//                    args.putParcelable("storeModel", model);
//                    UserModel userModel=new UserModel();
//                    userModel.id = item.userId;
//                    userModel.username = item.userName;
//                    userModel.setProfilePic(item.userPicture);
//                    args.putParcelable("userModel",userModel);
//                    fragment.setArguments(args);
//                    fragment.show(getChildFragmentManager(), "TaggedProductDetailF3");
//                }


            }
        });
        binding.productRecylerVeiw.setAdapter(productsAdapter);

    }


    private void sendComment() {
        EditTextSheetFragment fragment = new EditTextSheetFragment("OwnComment", taggedUserList, new FragmentCallBack() {
            @Override
            public void onResponce(Bundle bundle) {
                if (bundle.getBoolean("isShow", false)) {
                    if (bundle.getString("action").equals("sendComment")) {
                        taggedUserList = (ArrayList<UserModel>) bundle.getSerializable("taggedUserList");
                        String message = bundle.getString("message");
                        binding.tvMessage.setText(message);
                        addMessages("comment");
                    }
                }
            }
        });
        Bundle bundle = new Bundle();
        bundle.putString("replyStr", "");
        fragment.setArguments(bundle);
        fragment.show(getChildFragmentManager(), "EditTextSheetF");
    }


    private void addLikeIntoStream() {
        StreamShowHeartModel likeData = new StreamShowHeartModel();
        likeData.setUserId(Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
        likeData.setOtherUserId(item.getUserId());
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").push().setValue(likeData).addOnCompleteListener(new OnCompleteListener<Void>() {
            @Override
            public void onComplete(@NonNull Task<Void> task) {
                if (task.isComplete()) {
                    isSendHeart = true;
                }
            }
        });
    }

    private void InitControl() {
        context = requireContext();
        rootref = FirebaseDatabase.getInstance().getReference();

        binding.btnfollow.setOnClickListener(this);

        binding.tvMessage.setOnClickListener(this);
        binding.tabLikeStreaming.setOnClickListener(this);


        binding.crossBtn.setOnClickListener(this);
        binding.crossBtn2.setOnClickListener(this);

        setUpJoinRecycler();
        initCommentAdapter();


        if (TextUtils.isEmpty(item.getSecureCode())) {
            binding.tabStreamView.setVisibility(View.VISIBLE);
            binding.tabLockStream.setVisibility(View.GONE);

            connectStreaming();

        } else {
            if (LiveUsersActivity.unlockStream.containsKey(item.getUserId())) {
                binding.tabStreamView.setVisibility(View.VISIBLE);
                binding.tabLockStream.setVisibility(View.GONE);

                connectStreaming();
            } else {
                binding.tabStreamView.setVisibility(View.GONE);
                binding.tabLockStream.setVisibility(View.VISIBLE);
                setupLockScreenData();
            }

        }


        checkUserStatus();
    }


    public void ListCommentData() {
        current_cal = Calendar.getInstance();
        if (commentChildListener == null) {
            commentChildListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {
                    LiveCommentModel model = dataSnapshot.getValue(LiveCommentModel.class);
                    dataList.add(model);

                    if (DateOprations.checkTimeDiffernce(current_cal, model.getCommentTime())) {
                        if (model.getType().equalsIgnoreCase("gift")) {
                            try {

                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        ShowGiftAnimation(model);
                                    }
                                });

                            } catch (Exception e) {
                            }

                        }
                    }


                    adapter.notifyDataSetChanged();
                    binding.recylerview.scrollToPosition(dataList.size() - 1);

                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot dataSnapshot) {
                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").limitToLast(1).addChildEventListener(commentChildListener);
        }
    }


    public void removeCommentListener() {
        if (rootref != null && commentChildListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").removeEventListener(commentChildListener);
            commentChildListener = null;
        }
    }


    public void initCommentAdapter() {
        dataList.clear();

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setStackFromEnd(true);
        binding.recylerview.setLayoutManager(linearLayoutManager);

        binding.recylerview.setHasFixedSize(true);

        adapter = new LiveCommentsAdapter(context, dataList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {
                LiveCommentModel itemUpdate = dataList.get(pos);
                if (view.getId() == R.id.profileImage) {
                    openProfile(itemUpdate.userId);
                } else if (view.getId() == R.id.username) {
                    openProfile(itemUpdate.userId);
                } else if (itemUpdate.getType().equals("shareStream")) {
                    inviteFriendsForStream();
                } else {
                    openProfile(itemUpdate.userId);
                }

            }
        });

        binding.recylerview.setAdapter(adapter);

    }

    public void openProfile(String userId) {
        if (Functions.checkProfileOpenValidation(userId)) {
            Intent intent = new Intent(getActivity(), ProfileActivity.class);
            intent.putExtra("user_id", userId);
            startActivity(intent);
            getActivity().overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left);
        }
    }

    // send the comment to the live user
    public void addLiveStreamingShareMessage(String type) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment("");
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);


        CameraRequestModel model = new CameraRequestModel();
        model.setRequestState("1");
        rootref.child("LiveStreamingUsers").child(item.getStreamingId())
                .child("CameraRequest")
                .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "0"))
                .setValue(model);
    }

    private void addNodeCameraRequest() {
        if (cameraRequestEventListener == null) {

            cameraRequestEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    if (snapshot.exists()) {
                        CameraRequestModel model = snapshot.getValue(CameraRequestModel.class);
                        if (model.getRequestState().equals("2")) {
                            Toast.makeText(context, context.getString(R.string.camera_request_granted), Toast.LENGTH_SHORT).show();
                            isCameraConnect = true;
                        } else if (model.getRequestState().equals("1")) {
                            isCameraConnect = false;
                        } else {

                            isCameraConnect = false;
                            stopBroadcast(activity.userRole);
                            Toast.makeText(context, context.getString(R.string.camera_request_rejected), Toast.LENGTH_SHORT).show();

                        }
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {
                    isCameraConnect = false;
                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId())
                    .child("CameraRequest")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "0"))
                    .addValueEventListener(cameraRequestEventListener);

        }
    }

    private void removeNodeCameraRequest() {
        if (rootref != null && cameraRequestEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId())
                    .child("CameraRequest")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "0"))
                    .removeEventListener(cameraRequestEventListener);
            cameraRequestEventListener = null;
        }
    }

    private void setUpScreenData() {
        binding.tvCoinCount.setText(item.getUserCoins());
        binding.tabMenu.setVisibility(View.GONE);
        binding.tvMainUserName.setText(item.getUserName());
        binding.ivMainProfile.setController(Functions.frescoImageLoad(item.getUserPicture(), binding.ivMainProfile, false));

        binding.profileLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openProfile(item.userId);
            }
        });

        if (item.getIsVerified()==1) {
            binding.ivVerified.setVisibility(View.VISIBLE);
        } else {
            binding.ivVerified.setVisibility(View.GONE);
        }


        if (item.getUserId().equalsIgnoreCase(Variables.sharedPreferences.getString(Variables.U_ID, ""))) {
            binding.tabGift.setVisibility(View.GONE);
        } else {
            binding.tabGift.setVisibility(View.VISIBLE);
        }


        if (item.pkInvitation != null && item.pkInvitation.pkStreamingId != null) {
            binding.tabCoHost.setVisibility(View.GONE);
        } else if (item.isDualStreaming && item.isStreamJoinAllow) {
            binding.tabCoHost.setVisibility(View.VISIBLE);
            addNodeCameraRequest();
        } else {
            binding.tabCoHost.setVisibility(View.GONE);
            removeNodeCameraRequest();
        }


    }

    private void setupLockScreenData() {
        binding.tvUserName.setText(item.getUserName());
        binding.ivProfile.setController(Functions.frescoBlurImageLoad(item.getUserPicture(), context, 75));
        binding.ivSmallProfile.setController(Functions.frescoImageLoad(item.getUserPicture(), binding.ivSmallProfile, false));
    }

    private void setUpJoinRecycler() {
        GridLayoutManager layoutManager = new GridLayoutManager(context, 2);
        layoutManager.setOrientation(RecyclerView.VERTICAL);
        binding.liveUserViewRecyclerView.setLayoutManager(layoutManager);
        liveUserViewAdapter = new LiveUserViewAdapter(context, jointUserList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {

            }
        });
        binding.liveUserViewRecyclerView.setAdapter(liveUserViewAdapter);
    }

    private void ListenerJoinNode() {
        if (joinValueEventListener == null) {
            joinValueEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                    jointUserList.clear();
                    if (dataSnapshot.exists()) {
                        for (DataSnapshot joinSnapsot : dataSnapshot.getChildren()) {
                            Log.d(Constants.tag, "Data JSON : " + joinSnapsot.getValue().toString());
                            if (!(TextUtils.isEmpty(joinSnapsot.getValue().toString()))) {
                                StreamJoinModel model = joinSnapsot.getValue(StreamJoinModel.class);
                                jointUserList.add(model);
                            }

                        }
                        liveUserViewAdapter.notifyDataSetChanged();
                        binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));

                    } else {
                        liveUserViewAdapter.notifyDataSetChanged();
                        binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {
                    liveUserViewAdapter.notifyDataSetChanged();
                    binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));
                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                    .addValueEventListener(joinValueEventListener);
        }
    }

    public void removeJoinListener() {
        if (rootref != null && joinValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream").removeEventListener(joinValueEventListener);
            joinValueEventListener = null;
        }
    }

    private void ListenerCoinNode() {
        if (coinValueEventListener == null) {
            coinValueEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                    senderCoinsList.clear();
                    if (dataSnapshot.exists()) {
                        for (DataSnapshot joinSnapsot : dataSnapshot.getChildren()) {
                            if (!(TextUtils.isEmpty(joinSnapsot.getValue().toString()))) {
                                LiveCoinsModel model = joinSnapsot.getValue(LiveCoinsModel.class);
                                senderCoinsList.add(model);
                            }
                        }
                        double maxCoins = 0;
                        LiveCoinsModel highCoinSender = null;
                        if (senderCoinsList.size() > 0) {
                            binding.tabCoinSender.setVisibility(View.VISIBLE);
                            maxCoins = Double.valueOf(senderCoinsList.get(0).getSendedCoins());
                            highCoinSender = senderCoinsList.get(0);
                        } else {
                            binding.tabCoinSender.setVisibility(View.GONE);
                        }
                        for (LiveCoinsModel item : senderCoinsList) {
                            if (Double.valueOf(item.getSendedCoins()) > maxCoins) {
                                maxCoins = Double.valueOf(item.getSendedCoins());
                                highCoinSender = item;
                            }
                        }
                        if (highCoinSender != null) {
                            binding.tvSender.setText(highCoinSender.getUserName());
                            binding.ivSender.setController(Functions.frescoImageLoad(highCoinSender.getUserPic(), binding.ivSender, false));
                        }


                    }

                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").addValueEventListener(coinValueEventListener);

        }
    }

    public void removeCoinListener() {
        if (rootref != null && coinValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").removeEventListener(coinValueEventListener);
            coinValueEventListener = null;
        }
    }

    private void AddJoinNode() {
        StreamJoinModel model = new StreamJoinModel();
        model.setUserId(Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
        model.setUserName(Functions.getSharedPreference(context).getString(Variables.U_NAME, ""));
        model.setUserPic(Functions.getSharedPreference(context).getString(Variables.U_PIC, ""));


        if (pkInvitation != null) {
            rootref.child("LiveStreamingUsers").child(pkInvitation.senderStreamingId).child("JoinStream")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                    .setValue(model);

            rootref.child("LiveStreamingUsers").child(pkInvitation.receiverStreamingId).child("JoinStream")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                    .setValue(model);
        } else {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                    .setValue(model);
        }


    }

    private void connectStreaming() {

        String streamingId = item.getStreamingId();
        if (pkInvitation != null && pkInvitation.pkStreamingId != null) {
            streamingId = pkInvitation.pkStreamingId;
            showPkBattleViews();
        } else {
            stopPkCountDown();
            hidePkBattleviews();

        }
        Log.d(Constants.tag, "connectStreaming StreamId:" + streamingId);
        activity.refreshStreamingConnection(streamingId);
    }

    private void startBroadcast(int role) {
        Log.d(Constants.tag, "Stream: startBroadcast as " + role);
        Log.d(Constants.tag, "Stream: startBroadcast with compare " + activity.userRole);
        String streamingId = item.getStreamingId();
        Log.d(Constants.tag, "startBroadcast StreamId:" + streamingId);

        SurfaceView surface = activity.startBroadcast(streamingId, role);
        TicTicApp ticTicApp = (TicTicApp) getActivity().getApplication();
        activity.mVideoGridContainer.addUserVideoSurface(Integer.parseInt(ticTicApp.engineConfig().getUid()), surface, true);
    }

    private void stopBroadcast(int role) {
        Log.d(Constants.tag, "Stream: stopBroadcast as " + role);
        Log.d(Constants.tag, "Stream: stopBroadcast with compare " + activity.userRole);
        activity.stopBroadcast(role);
        TicTicApp ticTicApp = (TicTicApp) getActivity().getApplication();
        activity.mVideoGridContainer.removeUserVideo(Integer.parseInt(ticTicApp.engineConfig().getUid()), true);

    }

    public void showPkBattleViews() {

        binding.pkProgressLayout.setVisibility(View.VISIBLE);
        binding.pkbattleTimerLayout.setVisibility(View.VISIBLE);
        binding.tabCoHost.setVisibility(View.GONE);

        startPkCountDown();
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
            @Override
            public void run() {

                try {

                    if (getActivity() != null) {
                        getActivity().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                showPkAnimation();
                            }
                        });
                    }

                } catch (Exception e) {
                }
            }
        }, 2500);

        AddJoinNode();
    }

    public void hidePkBattleviews() {
        binding.pkProgressLayout.setVisibility(View.GONE);
        binding.pkbattleTimerLayout.setVisibility(View.GONE);
        binding.tabCoHost.setVisibility(View.VISIBLE);
    }

    public void showPkAnimation() {
        binding.pkgif.setVisibility(View.VISIBLE);
        ControllerListener controllerListener = new BaseControllerListener<ImageInfo>() {
            @Override
            public void onFinalImageSet(
                    String id,
                    @Nullable ImageInfo imageInfo,
                    @Nullable Animatable anim) {
                if (anim != null) {
                    // com-specific logic to enable animation starting
                    anim.start();
                    removeGifCallback();
                    pkGifRunable = new Runnable() {
                        @Override
                        public void run() {

                            try {

                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            binding.pkgif.setVisibility(View.GONE);
                                        }
                                    });
                                }

                            } catch (Exception e) {
                            }

                        }
                    };
                    pkGifHandler = new Handler(Looper.getMainLooper());
                    pkGifHandler.postDelayed(pkGifRunable, 1800);


                    Functions.printLog(Constants.tag, "onFinalImageSet");
                }
            }
        };

        ImageRequest request = ImageRequestBuilder.newBuilderWithResourceId(R.raw.ic_pk_battle2)
                .build();
        DraweeController controller = Fresco.newDraweeControllerBuilder()
                .setImageRequest(request)
                .setAutoPlayAnimations(false)
                .setOldController(binding.pkgif.getController())
                .setControllerListener(controllerListener)
                .build();

        binding.pkgif.setController(controller);


    }

    public void removeGifCallback() {
        if (pkGifHandler != null && pkGifRunable != null) {
            pkGifHandler.removeCallbacks(pkGifRunable);
        }
    }

    public void startPkCountDown() {
        if (pkBattleCountDown == null && item.pkInvitation != null) {


            rootref.child(Variables.onlineUser).
                    child(Functions.getSharedPreference(getActivity()).getString(Variables.U_ID, "0"))
                    .child("timeStamp").setValue(ServerValue.TIMESTAMP);

            rootref.child(Variables.onlineUser).
                    child(Functions.getSharedPreference(getActivity()).getString(Variables.U_ID, "0")).addListenerForSingleValueEvent(new ValueEventListener() {
                        @Override
                        public void onDataChange(@NonNull DataSnapshot snapshot) {
                            long value = (long) snapshot.child("timeStamp").getValue();
                            long dif = value - item.pkInvitation.timeStamp;
                            long timeDiffernce = Constants.PkBattleTime - dif;

                            pkBattleCountDown = new CountDownTimer(timeDiffernce, 1000) {
                                @Override
                                public void onTick(long l) {
                                    binding.pkTimerTxt.setText(DateOperations.INSTANCE.getDate(l, "mm:ss"));
                                }

                                @Override
                                public void onFinish() {
                                    hidePkBattleviews();

                                    if (pkInvitation != null) {
                                        showWinningGif();
                                    }

                                }
                            };
                            pkBattleCountDown.start();

                            Functions.printLog(Constants.tag, "difference..." + value);
                        }

                        @Override
                        public void onCancelled(@NonNull DatabaseError error) {

                        }
                    });


        }
    }


//    public void heartsShow()
//    {
//        binding.streamLikeView.addHeart(new Random().nextInt(5));
//    }

    public void stopPkCountDown() {
        if (pkBattleCountDown != null) {
            pkBattleCountDown.cancel();
        }
    }

    private void showWinningGif() {

        int user1Coins = pkInvitation.senderCoins;
        int user2Coins = pkInvitation.receiverCoins;

        String winningSide = "0";

        if (user1Coins > user2Coins) {
            if (pkInvitation.senderId.equalsIgnoreCase(item.userId)) {
                winningSide = "1";
            } else {
                winningSide = "2";
            }
        } else if (user2Coins > user1Coins) {
            if (pkInvitation.receiverId.equalsIgnoreCase(item.userId)) {
                winningSide = "1";
            } else {
                winningSide = "2";
            }
        }

        if (winningSide.equals("1")) {

            binding.winningLayout.setVisibility(View.VISIBLE);


            ImageRequest request = ImageRequestBuilder.newBuilderWithResourceId(R.raw.ic_winning_stars)
                    .build();
            DraweeController controller = Fresco.newDraweeControllerBuilder()
                    .setImageRequest(request)
                    .setOldController(binding.winningGif1.getController())
                    .setAutoPlayAnimations(true)
                    .build();

            binding.winningGif1.setController(controller);
        } else if (winningSide.equals("2")) {

            binding.winningLayout.setVisibility(View.VISIBLE);

            ImageRequest request = ImageRequestBuilder.newBuilderWithResourceId(R.raw.ic_winning_stars)
                    .build();
            DraweeController controller = Fresco.newDraweeControllerBuilder()
                    .setImageRequest(request)
                    .setOldController(binding.winningGif2.getController())
                    .setAutoPlayAnimations(true)
                    .build();

            binding.winningGif2.setController(controller);
        }

        if (winningHandler != null && winningRunnable != null) {
            winningHandler.removeCallbacks(winningRunnable);
        }

        winningHandler = new Handler(Looper.getMainLooper());
        winningRunnable = new Runnable() {
            @Override
            public void run() {

                try {

                    getActivity().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            binding.winningLayout.setVisibility(View.GONE);
                            showPkWinnerDialog();
                        }
                    });
                } catch (Exception e) {
                }

            }
        };
        winningHandler.postDelayed(winningRunnable, 5000);
    }

    public void showPkWinnerDialog() {
        String winnerUsername = null;
        int coins = 0;
        int user1Coins = pkInvitation.senderCoins;
        int user2Coins = pkInvitation.receiverCoins;

        if (user1Coins > user2Coins) {
            winnerUsername = pkInvitation.senderName;
            coins = user1Coins;
        } else if (user2Coins > user1Coins) {
            winnerUsername = pkInvitation.receiverName;
            coins = user2Coins;
        }


        if (winnerUsername != null) {
            Dialog dialog = new Dialog(getContext());
            dialog.setCancelable(true);
            dialog.setContentView(R.layout.item_pk_winner_dialog);
            dialog.getWindow().setBackgroundDrawable(getActivity().getDrawable(R.drawable.d_round_white_background));

            final TextView usernametxt = dialog.findViewById(R.id.usernametxt);
            usernametxt.setText(winnerUsername);

            final TextView cointxt = dialog.findViewById(R.id.coinTxt);
            cointxt.setText("" + coins);


            dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialogInterface) {

                }
            });
            dialog.show();
        }
    }

    public void addPkBattleStreamingListener() {
        if (pklistener == null) {
            pklistener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    if (snapshot.exists()) {
                        pkInvitation = snapshot.getValue(PkInvitation.class);

                        if (item.pkInvitation != null && item.pkInvitation.pkStreamingId != null) {

                        } else if (pkInvitation != null && pkInvitation.pkStreamingId != null) {
                            item.pkInvitation = pkInvitation;
                            activity.removeStreamingConnection();
                            Log.d(Constants.tag, "connectStreaming pklistener snapshot.exists()");
                            connectStreaming();
                        }

                        if (item.userId.equalsIgnoreCase(pkInvitation.senderId)) {
                            binding.coinCount1Txt.setText("" + pkInvitation.senderCoins);
                            binding.coinCount2Txt.setText("" + pkInvitation.receiverCoins);
                        }

                        if (item.userId.equalsIgnoreCase(pkInvitation.receiverId)) {
                            binding.coinCount1Txt.setText("" + pkInvitation.receiverCoins);
                            binding.coinCount2Txt.setText("" + pkInvitation.senderCoins);
                        }

                        updatePkBar();


                    } else if (item.pkInvitation != null && item.pkInvitation.pkStreamingId != null) {

                        if (pkInvitation.senderId.equals(item.userId)) {
                            rootref.child("LiveStreamingUsers").child(pkInvitation.receiverStreamingId).child("JoinStream")
                                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "")).removeValue();

                        } else {
                            rootref.child("LiveStreamingUsers").child(pkInvitation.senderStreamingId).child("JoinStream")
                                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "")).removeValue();
                        }

                        binding.liveVideoGridLayout.removeUserVideo(Integer.parseInt(pkInvitation.senderId), false);
                        binding.liveVideoGridLayout.removeUserVideo(Integer.parseInt(pkInvitation.receiverId), false);

                        pkInvitation = null;
                        item.pkInvitation = null;
                        activity.removeStreamingConnection();
                        Log.d(Constants.tag, "connectStreaming pklistener !snapshot.exists()");
                        connectStreaming();
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.streamingId).child("pkInvitation").addValueEventListener(pklistener);
        }
    }

    public void removePkBattleStreamingListener() {
        try {

            if (rootref != null && pklistener != null) {
                rootref.child("LiveStreamingUsers").child(item.streamingId).child("pkInvitation").removeEventListener(pklistener);
            }
        } catch (Exception e) {
        }
    }

    public void updatePkBar() {
        if (item.userId.equalsIgnoreCase(pkInvitation.senderId)) {
            int user1Coins = pkInvitation.senderCoins;
            int user2Coins = pkInvitation.receiverCoins;

            int total = user1Coins + user2Coins;
            if (total > 0) {
                int percentage1 = ((user1Coins * 100) / total);
                int percentage2 = 100 - percentage1;

                Functions.printLog(Constants.tag, percentage1 + "--" + percentage2);

                binding.pkProgressbar.setFirstSectionPercentage(percentage1);
                binding.pkProgressbar.setSecondSectionPercentage(percentage2);
            } else {
                binding.pkProgressbar.setFirstSectionPercentage(50);
                binding.pkProgressbar.setSecondSectionPercentage(50);
            }

        } else if (item.userId.equalsIgnoreCase(pkInvitation.receiverId)) {
            int user1Coins = pkInvitation.receiverCoins;
            int user2Coins = pkInvitation.senderCoins;

            int total = user1Coins + user2Coins;
            if (total > 0) {
                int percentage1 = ((user1Coins * 100) / total);
                int percentage2 = 100 - percentage1;

                Functions.printLog(Constants.tag, percentage1 + "--" + percentage2);

                binding.pkProgressbar.setFirstSectionPercentage(percentage1);
                binding.pkProgressbar.setSecondSectionPercentage(percentage2);
            } else {
                binding.pkProgressbar.setFirstSectionPercentage(50);
                binding.pkProgressbar.setSecondSectionPercentage(50);
            }
        }
    }

    // when user goes to offline then change the value status on firebase
    public void removeJoinNode() {

        if (rootref != null) {

            if (pkInvitation != null) {
                rootref.child("LiveStreamingUsers").child(pkInvitation.receiverStreamingId).child("JoinStream")
                        .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "")).removeValue();

                rootref.child("LiveStreamingUsers").child(pkInvitation.senderStreamingId).child("JoinStream")
                        .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "")).removeValue();

            } else {
                rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                        .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                        .removeValue();
            }

        }
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.cross_btn: {
                getActivity().finish();
            }
            break;
            case R.id.cross_btn2: {
                getActivity().finish();
            }
            break;
            case R.id.tabMenu: {
                ShowDailogForJoinBroadcast();
            }
            break;
            case R.id.tabLikeStreaming: {
                if (isSendHeart) {
                    isSendHeart = true;
                    addLikeIntoStream();
                }
            }
            break;
            case R.id.tabGift: {
                ShowGiftSheet();

            }
            break;
            case R.id.tabInviteAll: {
                inviteFriendsForStream();
            }
            break;
            case R.id.tabCoHost: {

                if (isCameraConnect) {
                    ShowDailogForJoinBroadcast();
                } else {
                    sendCameraRequest();
                }

            }
            break;
            case R.id.tabStartLive: {
                if (item.getSecureCode().equals(binding.pinView.getText().toString())) {
                    LiveUsersActivity.unlockStream.put(item.getUserId(), binding.pinView.getText().toString());
                    binding.tabStreamView.setVisibility(View.VISIBLE);
                    binding.tabLockStream.setVisibility(View.GONE);

                    connectStreaming();
                }

            }
            break;


            case R.id.tvMessage: {
                sendComment();
            }
            break;

            case R.id.btnfollow: {
                if (Functions.checkLoginUser(getActivity()))
                    followUnFollowUser();
            }
            break;

        }
    }

    private void followUnFollowUser() {
        ApiRepository.callApiForFollowUnFollow(getActivity(),
                Functions.getSharedPreference(context).getString(Variables.U_ID, ""),
                item.getUserId(),
                new APICallBack() {
                    @Override
                    public void arrayData(ArrayList arrayList) {
                    }

                    @Override
                    public void onSuccess(String responce) {

                        callApiForGetAllvideos(item.getUserId(), item.getUserName());
                    }

                    @Override
                    public void onFail(String responce) {

                    }

                });
    }

    private void callApiForGetAllvideos(String userId, String userName) {

        JSONObject parameters = new JSONObject();
        try {

            if (Functions.getSharedPreference(context).getBoolean(Variables.IS_LOGIN, false)) {
                if (userId != null && userName != null) {
                    if (userId.equals(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))) {
                        parameters.put("user_id", userId);
                    } else {
                        parameters.put("user_id", Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
                        parameters.put("other_user_id", userId);
                    }

                } else {
                    parameters.put("user_id", Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
                    parameters.put("username", userName);
                }
            } else {
                if (userId != null && userName != null) {
                    parameters.put("user_id", userId);
                } else {
                    parameters.put("username", userName);
                }
            }

        } catch (Exception e) {
            Log.d(Constants.tag, "Exception: " + e);
        }


        VolleyRequest.JsonPostRequest(getActivity(), ApiLinks.showUserDetail, parameters, Functions.getHeaders(getActivity()), new Callback() {
            @Override
            public void onResponce(String resp) {
                Functions.checkStatus(getActivity(), resp);
                isRunFirstTime = true;
                try {
                    JSONObject jsonObject = new JSONObject(resp);
                    String code = jsonObject.optString("code");
                    if (code.equals("200")) {
                        JSONObject msg = jsonObject.optJSONObject("msg");

                        UserModel userDetailModel = DataParsing.getUserDataModel(msg.optJSONObject("User"));
                        String follow_status = userDetailModel.button.toLowerCase();
                        if (!userDetailModel.id.
                                equals(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))) {

                            if (follow_status.equalsIgnoreCase("following")) {
                                binding.btnfollow.setVisibility(View.GONE);
                            } else if (follow_status.equalsIgnoreCase("friends")) {
                                binding.btnfollow.setVisibility(View.GONE);
                            } else if (follow_status.equalsIgnoreCase("follow back")) {

                                binding.btnfollow.setVisibility(View.VISIBLE);
                                binding.btnfollow.setText(getString(R.string.follow_back));
                            } else {
                                binding.btnfollow.setVisibility(View.VISIBLE);
                                binding.btnfollow.setText(getString(R.string.follow));
                            }


                        }


                    }
                } catch (Exception e) {
                    Log.d(Constants.tag, "Exception: " + e);
                }
            }
        });

    }

    private void sendCameraRequest() {
        if (selfInvitehandler == null) {
            addLiveStreamingShareMessage("selfInviteForStream");
            selfInvitehandler = new CountDownTimer((5 * 60 * 1000), (1000)) {
                @Override
                public void onTick(long l) {
                    selfInviteRemainingTime = (int) (l / 1000);
                }

                @Override
                public void onFinish() {
                    selfInviteRemainingTime = 0;
                    selfInvitehandler = null;
                }
            }.start();
        } else {
            Toast.makeText(context, context.getString(R.string.you_can_send_join_request_after) + " " + selfInviteRemainingTime + "sec", Toast.LENGTH_SHORT).show();
        }
    }

    private void inviteFriendsForStream() {
        InviteContactsToStreamFragment f = new InviteContactsToStreamFragment(item.getStreamingId(), "multiple", new FragmentCallBack() {
            @Override
            public void onResponce(Bundle bundle) {
                if (bundle.getBoolean("isShow", false)) {

                }
            }
        });
        f.show(getChildFragmentManager(), "InviteContactsToStreamF");
    }

    private void showAllUserLikes() {
        if (!(item.getUserId().equalsIgnoreCase(Variables.sharedPreferences.getString(Variables.U_ID, "")))) {
            if (isLikeStream) {
                addLikeComment("like");
                isLikeStream = false;
            }
        }
    }

    public void ShowDailogForJoinBroadcast() {
        final Dialog alertDialog = new Dialog(context);
        alertDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        alertDialog.setContentView(R.layout.live_join_broadcast_view);
        alertDialog.getWindow().setBackgroundDrawable(ContextCompat.getDrawable(context, R.drawable.d_round_white_background));

        ImageView swith_camera_btn = alertDialog.findViewById(R.id.swith_camera_btn);
        ImageView live_btn_mute_audio = alertDialog.findViewById(R.id.live_btn_mute_audio);
        ImageView live_btn_beautification = alertDialog.findViewById(R.id.live_btn_beautification);
        ImageView live_btn_mute_video = alertDialog.findViewById(R.id.live_btn_mute_video);
        RelativeLayout tab_cancel = alertDialog.findViewById(R.id.tab_cancel);
        ImageView closeBtn = alertDialog.findViewById(R.id.closeBtn);
        LinearLayout tabClient = alertDialog.findViewById(R.id.tabClient);
        LinearLayout tabSwitch = alertDialog.findViewById(R.id.tabSwitch);

        if (!item.isDualStreaming) {
            if (!(item.getOnlineType().equals("oneTwoOne"))) {
                tabClient.setVisibility(View.GONE);
                tabSwitch.setVisibility(View.GONE);
            }
        }


        closeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });

        live_btn_mute_audio.setActivated(!isAudioActivated);
        live_btn_mute_video.setActivated(!isVideoActivated);
        live_btn_beautification.setActivated(!isbeautyActivated);

        activity.setBeautyEffectOptions(live_btn_mute_video.isActivated());

        tab_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
                getActivity().onBackPressed();
            }
        });
        swith_camera_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                activity.switchCamera();
            }
        });
        live_btn_mute_audio.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isAudioActivated = live_btn_mute_video.isActivated();
                if (!isAudioActivated) return;
                activity.muteLocalAudioStream(isAudioActivated);
                view.setActivated(!isAudioActivated);
            }
        });
        live_btn_beautification.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isbeautyActivated = view.isActivated();
                view.setActivated(!isbeautyActivated);
                activity.setBeautyEffectOptions(isbeautyActivated);
            }
        });
        live_btn_mute_video.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isVideoActivated = view.isActivated();
                if (isVideoActivated) {
                    activity.userRole = io.agora.rtc2.Constants.CLIENT_ROLE_AUDIENCE;
                    stopBroadcast(io.agora.rtc2.Constants.CLIENT_ROLE_AUDIENCE);
                } else {
                    activity.userRole = io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER;
                    startBroadcast(io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER);
                }
                view.setActivated(!isVideoActivated);
            }
        });
        alertDialog.show();
    }

    public void ShowGiftSheet() {

        StickerGiftFragment giftFragment = new StickerGiftFragment(item.getUserId(), item.getUserName(), item.getUserPicture(), new FragmentCallBack() {
            @Override
            public void onResponce(Bundle bundle) {
                if (bundle.getBoolean("isShow", false)) {
                    StickerModel model = (StickerModel) bundle.getSerializable("Data");
                    String counter = bundle.getString("count");
                    addGiftComment("gift", counter, model);

                    Log.d(Constants.tag, "Test : " + item.getUserCoins());


                    if (item != null) {
                        double userGift = (Long.valueOf(counter) * Double.valueOf(model.coins));
                        HashMap map = new HashMap();
                        map.put("userCoins", "" + userGift);
                        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).updateChildren(map);

                        if (item.pkInvitation != null && item.pkInvitation.pkStreamingId != null) {

                            String[] streamingIds = item.pkInvitation.pkStreamingId.split("PK");

                            if (item.getUserId().equalsIgnoreCase(item.pkInvitation.senderId)) {
                                rootref.child("LiveStreamingUsers").child(streamingIds[0]).child("pkInvitation").child("senderCoins").setValue(item.pkInvitation.senderCoins + userGift);
                                rootref.child("LiveStreamingUsers").child(streamingIds[1]).child("pkInvitation").child("senderCoins").setValue(item.pkInvitation.senderCoins + userGift);

                            } else if (item.getUserId().equalsIgnoreCase(item.pkInvitation.receiverId)) {
                                rootref.child("LiveStreamingUsers").child(streamingIds[0]).child("pkInvitation").child("receiverCoins").setValue(item.pkInvitation.receiverCoins + userGift);
                                rootref.child("LiveStreamingUsers").child(streamingIds[1]).child("pkInvitation").child("receiverCoins").setValue(item.pkInvitation.receiverCoins + userGift);
                            }

                        }

                    }
                } else {
                    if (bundle.getBoolean("showCount", false)) {
                        StickerModel model = (StickerModel) bundle.getSerializable("Data");
                        binding.tvGiftCount.setText(" X " + bundle.getString("count") + " " + model.name);

                        binding.ivGiftCount.setController(Functions.frescoImageLoad(model.image, binding.ivGiftCount, false));

                        binding.tabGiftCount.animate().translationY(binding.animationCapture.getY()).setDuration(700).setListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationStart(Animator animation) {
                                super.onAnimationStart(animation);
                                binding.tabGiftCount.setAlpha(1);
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                super.onAnimationEnd(animation);
                                binding.tabGiftCount.clearAnimation();
                                binding.tabGiftCount.animate().alpha(0).translationY(0).setListener(new AnimatorListenerAdapter() {
                                    @Override
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        binding.tabGiftCount.clearAnimation();
                                    }
                                }).start();

                            }
                        }).start();

                    }
                }
            }
        });
        giftFragment.show(getChildFragmentManager(), "");
    }

    public void ShowGiftAnimation(LiveCommentModel item) {

        String[] str = item.getComment().split("=====");

        Uri imageUri = Uri.parse(str[2]);

        binding.ivGiftProfile.setController(Functions.frescoImageLoad(item.getUserPicture(), binding.ivGiftProfile, false));

        binding.ivGiftItem.setController(Functions.frescoImageLoad("" + imageUri, binding.ivGiftItem, false));
        binding.tvGiftTitle.setText(item.getUserName());
        binding.tvGiftCountTitle.setText(getString(R.string.gave_you_a) + " " + str[1]);
        binding.tvSendGiftCount.setText("X " + str[0]);

        binding.tabGiftMain.animate().alpha(1).translationX(binding.animationGiftCapture.getX()).setDuration(3000).setListener(
                new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        binding.tabGiftMain.animate().translationY(binding.animationCapture.getY()).setDuration(1000).setListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                super.onAnimationEnd(animation);
                                binding.tabGiftMain.clearAnimation();
                                binding.tabGiftMain.animate().alpha(0).translationY(binding.animationResetAnimation.getY()).translationX(binding.animationResetAnimation.getX()).setListener(new AnimatorListenerAdapter() {
                                    @Override
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        binding.tabGiftMain.clearAnimation();
                                    }
                                }).start();
                            }
                        }).start();
                    }


                    @Override
                    public void onAnimationStart(Animator animation) {
                        super.onAnimationStart(animation);
                        PlayGiftSound();
                    }
                }).start();

        if (str[2] != null && str[2].contains(".gif")) {
            showGiftAnimation(str[2], item);
        }

    }

    public void showGiftAnimation(String gifUrl, LiveCommentModel item) {
        Functions.printLog(Constants.tag, "showGiftAnimation");
        binding.pkgiftGif.setVisibility(View.VISIBLE);
        ControllerListener controllerListener = new BaseControllerListener<ImageInfo>() {
            @Override
            public void onFinalImageSet(
                    String id,
                    @Nullable ImageInfo imageInfo,
                    @Nullable Animatable anim) {
                if (anim != null) {

                    Functions.printLog(Constants.tag, "onFinalImageSet");

                    if (item.getSound() != null && !item.getSound().equals("")) {
                        downloadSound(anim, item);
                    } else {
                        startAnimation(anim, item.getTime());
                    }


                } else {
                    Functions.printLog(Constants.tag, "onFinalImageSet anim null");
                }
            }
        };

        ImageRequest request = ImageRequest.fromUri(gifUrl);


        DraweeController controller = Fresco.newDraweeControllerBuilder()
                .setImageRequest(request)
                .setAutoPlayAnimations(true)
                .setOldController(binding.pkgiftGif.getController())
                .setControllerListener(controllerListener)
                .build();

        binding.pkgiftGif.setController(controller);


    }    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            onTuneStop();
        }
    };

    public void downloadSound(Animatable anim, LiveCommentModel item) {
        Functions.printLog(Constants.tag, "soundUrl" + item.getSound());
        File file = new File(FileUtils.getAppFolder(getActivity()) + Variables.APP_HIDED_FOLDER + Variables.gift_sound);
        if (file.exists()) {
            file.delete();
        }

        PRDownloader.initialize(getActivity());
        DownloadRequest prDownloader = PRDownloader.download(item.getSound(), FileUtils.getAppFolder(getActivity()) + Variables.APP_HIDED_FOLDER, Variables.gift_sound)
                .build()
                .setOnProgressListener(new OnProgressListener() {
                    @Override
                    public void onProgress(Progress progress) {

                        int prog = (int) ((progress.currentBytes * 100) / progress.totalBytes);
                        Dialogs.showLoadingProgress(prog);

                    }
                });

        prDownloader.start(new OnDownloadListener() {
            @Override
            public void onDownloadComplete() {
                Dialogs.cancelDeterminentLoader();
                preparedAudio(anim, item);

            }

            @Override
            public void onError(Error error) {

                Functions.printLog(Constants.tag, "Error : " + error.getConnectionException());
                Dialogs.cancelDeterminentLoader();
            }


        });


    }

    public void startAnimation(Animatable anim, String time) {

        Functions.printLog(Constants.tag, "Time:" + time);

        int sec = Integer.parseInt(time);
        if (sec == 0) {
            sec = 2;
        }
        int duration = (sec * 1000);
        anim.start();
        new CountDownTimer(duration, 300) {
            @Override
            public void onTick(long l) {

            }

            @Override
            public void onFinish() {
                anim.stop();
                binding.pkgiftGif.setVisibility(View.GONE);
            }
        }.start();
    }

    public void preparedAudio(Animatable anim, LiveCommentModel item) {
        File file = new File(FileUtils.getAppFolder(getActivity()) + Variables.APP_HIDED_FOLDER + Variables.gift_sound);
        if (file.exists()) {
            try {
                audio = new MediaPlayer();
                try {
                    audio.setDataSource(FileUtils.getAppFolder(getActivity()) + Variables.APP_HIDED_FOLDER + Variables.gift_sound);
                    player.setVolume(100, 100);
                    audio.prepare();

                    audio.start();
                } catch (Exception e) {
                    e.printStackTrace();
                }


                startAnimation(anim, item.getTime());


            } catch (Exception e) {
                Log.d(Constants.tag, "Exception : " + e);
            }

        }

    }

    private void PlayGiftSound() {
        handler = new Handler(Looper.getMainLooper());
        player = MediaPlayer.create(context, R.raw.gift_tone);
        player.setAudioStreamType(AudioManager.STREAM_MUSIC);
        player.setVolume(100, 100);
        player.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
            @Override
            public void onPrepared(MediaPlayer mp) {
                mp.start();
            }
        });
        handler.postDelayed(runnable, 2000);
    }

    public void onTuneStop() {
        if (player != null && player.isPlaying()) {
            player.stop();
        }
        if (handler != null) {
            handler.removeCallbacks(runnable);
        }
    }

    // send the comment to the live user
    public void addMessages(String type) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(binding.tvMessage.getText().toString());
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    // send the comment to the live user
    public void addLikeComment(String type) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(my_name + " " + getString(R.string.like_this_stream));
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    // send the comment to the live user
    public void addGiftComment(String type, String count, StickerModel model) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(count + "=====" + model.name + "=====" + model.image);
        commentItem.setType(type);
        commentItem.setTime(model.time);
        commentItem.setCommentTime(formattedDate);
        commentItem.setSound(model.sound);

        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);

        LiveCoinsModel coinsModel = new LiveCoinsModel();
        coinsModel.setUserId(my_id);
        coinsModel.setUserName(my_name);
        coinsModel.setUserPic(my_image);
        coinsModel.setSendedCoins("" + (Double.valueOf(count) * Double.valueOf(model.coins)));
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).addListenerForSingleValueEvent(new ValueEventListener() {
            @Override
            public void onDataChange(@NonNull DataSnapshot snapshot) {
                if (snapshot.exists()) {
                    LiveCoinsModel preModel = snapshot.getValue(LiveCoinsModel.class);
                    double totalCoins = Double.valueOf(preModel.getSendedCoins());
                    totalCoins = totalCoins + ((Double.valueOf(count) * Double.valueOf(model.coins)));

                    HashMap<String, Object> updateMap = new HashMap<>();
                    updateMap.put("sendedCoins", "" + totalCoins);

                    rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).updateChildren(updateMap);
                } else {
                    rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).setValue(coinsModel);
                }
            }

            @Override
            public void onCancelled(@NonNull DatabaseError error) {

            }
        });

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    @Override
    public void setMenuVisibility(boolean menuVisible) {
        super.setMenuVisibility(menuVisible);
        isVisible = menuVisible;

        if (menuVisible) {
            onResume();

        }
    }

    @Override
    public void onResume() {
        super.onResume();

        if (isVisible) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {

                    InitControl();
                    ActionControl();
                }
            }, 200);

        }
    }

    private void checkUserStatus() {
        if (userLiveStatusListener == null) {
            userLiveStatusListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    try {

                        if (getActivity() != null) {
                            getActivity().runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    if (snapshot.exists()) {
                                        item = snapshot.getValue(LiveUserModel.class);
                                        activity.updateLiveModel(item);
                                        binding.tabStreamView.setVisibility(View.VISIBLE);
                                        binding.tabOfflineView.setVisibility(View.GONE);

                                        Log.d(Constants.tag, "Stream: userChange");
                                        setUpScreenData();
                                        lounchStreamerCam();

                                    } else {
                                        binding.tabStreamView.setVisibility(View.GONE);
                                        binding.tabOfflineView.setVisibility(View.VISIBLE);
                                    }
                                }
                            });
                        }

                    } catch (Exception e) {
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {
                    binding.tabStreamView.setVisibility(View.GONE);
                    binding.tabOfflineView.setVisibility(View.VISIBLE);
                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).addValueEventListener(userLiveStatusListener);
        }

    }

    private void removeUserStatus() {
        if (rootref != null && userLiveStatusListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).removeEventListener(userLiveStatusListener);
            userLiveStatusListener = null;
        }
    }

    private void lounchStreamerCam() {
        InitNodeListener();
        addBlockStatusStream();

    }

    private void InitNodeListener() {

        joinStream();
        AddJoinNode();
        ListenerCoinNode();
        ListenerJoinNode();
        ListCommentData();
        addProductListener();
        addLikeStream();
        addStreamerOnlineStatus();
        addPkBattleStreamingListener();
        callApiForGetAllvideos(item.getUserId(), item.getUserName());
    }

    private void addBlockStatusStream() {
        if (blockValueEventListener == null) {

            blockValueEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    if (snapshot.exists()) {
                        String blockStatus = (String) snapshot.child("blockState").getValue();
                        performBlockAction(blockStatus);
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };

            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("BlockStreaming")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                    .addValueEventListener(blockValueEventListener);

        }

    }

    private void performBlockAction(String blockStatus) {
        if (blockStatus.equals("1")) {
            Toast.makeText(context, context.getString(R.string.your_are_blocked_on_this_stream), Toast.LENGTH_SHORT).show();
            binding.tabStreamView.setVisibility(View.GONE);
            binding.tabOfflineView.setVisibility(View.VISIBLE);
            removeNodeListener();
        }
    }

    private void removeBlockStatusStream() {
        if (rootref != null && blockValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("BlockStreaming")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, "")).removeEventListener(blockValueEventListener);
            blockValueEventListener = null;
        }
    }

    private void addLikeStream() {
        if (likeValueEventListener == null) {

            likeValueEventListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {
                    if (snapshot.exists()) {
                        StreamShowHeartModel likeData = snapshot.getValue(StreamShowHeartModel.class);

                        if (getActivity() != null) {
                            getActivity().runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    heartCounter = heartCounter + 1;
                                    binding.tvOtherUserLikes.setText(Functions.getSuffix("" + heartCounter) + " " + context.getString(R.string.likes));
                                    //heartsShow();
                                }
                            });
                        }

                    }
                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot snapshot) {

                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").addChildEventListener(likeValueEventListener);

        }
    }

    public void removeLikeStream() {
        if (rootref != null && likeValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").removeEventListener(likeValueEventListener);
            likeValueEventListener = null;
        }

    }

    private void joinStream() {
        boolean isBroadcaster = false;
        isAudioActivated = !isBroadcaster;
        isVideoActivated = !isBroadcaster;
        isbeautyActivated = false;
        activity.setBeautyEffectOptions(isbeautyActivated);
        activity.mVideoGridContainer = binding.liveVideoGridLayout;
        activity.videoGridMainLayout = binding.videoGridMainLayout;
        activity.mVideoGridContainer.setMainParentLayout(binding.videoGridMainLayout);
        activity.mVideoGridContainer.setStatsManager(activity.setStatsManager());
        activity.setClientRole(activity.userRole);
        if (isBroadcaster) {
            startBroadcast(activity.userRole);
        }
        activity.mVideoDimension = activity.getconfigDimenIndex();
    }

    private void addStreamerOnlineStatus() {
        if (streamerOnlineListener == null) {
            streamerOnlineListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {
                    if (!(TextUtils.isEmpty(snapshot.getValue().toString()))) {
                        UserOnlineModel itemUpdate = snapshot.getValue(UserOnlineModel.class);
                        if (item.getUserId().equalsIgnoreCase(itemUpdate.getUserId())) {
                            if (timer != null) {
                                Dialogs.cancelIndeterminentLoader();
                                timer.cancel();
                            }
                        }

                    }
                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot snapshot) {
                    try {
                        if (!(TextUtils.isEmpty(snapshot.getValue().toString()))) {

                            getActivity().runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    UserOnlineModel itemUpdate = snapshot.getValue(UserOnlineModel.class);
                                    if (item.getUserId().equalsIgnoreCase(itemUpdate.getUserId())) {
                                        Dialogs.showIndeterminentLoader(getActivity(), itemUpdate.getUserName() + " " + context.getString(R.string.single_is_week)
                                                , false, false);
                                        timer.cancel();
                                        timer = new Timer();
                                        timer.schedule(
                                                new TimerTask() {
                                                    @Override
                                                    public void run() {
                                                        getActivity().runOnUiThread(new Runnable() {
                                                            @Override
                                                            public void run() {
                                                                Dialogs.cancelIndeterminentLoader();
                                                                rootref.child("LiveStreamingUsers").child(item.getStreamingId()).removeValue();
                                                            }
                                                        });
                                                    }
                                                },
                                                DELAY
                                        );
                                    }

                                }
                            });

                        }
                    } catch (Exception e) {
                    }

                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };
            rootref.child(Variables.onlineUser).addChildEventListener(streamerOnlineListener);

        }
    }

    private void removeStreamerOnlineStatus() {
        if (rootref != null && streamerOnlineListener != null) {
            rootref.child(Variables.onlineUser).removeEventListener(streamerOnlineListener);
            streamerOnlineListener = null;
        }
    }

    @Override
    public void onPause() {
        removeGifCallback();
        removeNodeListener();
        removeBlockStatusStream();
        super.onPause();
    }

    private void removeNodeListener() {

        activity.removeStreamingConnection();
        removePkBattleStreamingListener();
        removeUserStatus();
        removeJoinNode();
        removeCoinListener();
        removeJoinListener();
        removeCommentListener();
        removeProductListener();
        removeLikeStream();
        removeStreamerOnlineStatus();
        if (item.isDualStreaming) {
            removeNodeCameraRequest();
        }

    }




}